/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.internal.flex;

import intrinsic.flash.events.MouseEvent;
import intrinsic.mx.core.Container;
import intrinsic.mx.core.EdgeMetrics;
import intrinsic.mx.core.ScrollControlBase;
import intrinsic.mx.events.ScrollEvent;
import intrinsic.mx.events.ScrollEventDirection;

public class SWTScrollControlBase extends ScrollControlBase implements intrinsic.mx.managers.IFocusManagerComponent {
	Container content;
	
public SWTScrollControlBase(Container content) {
	this.content = content;
}

public Container getContent() {
	return content;
}

protected void updateDisplayList(double unscaledWidth, double unscaledHeight) {
	super.updateDisplayList(unscaledWidth, unscaledHeight);
	
	EdgeMetrics vm = viewMetrics;
	double w = unscaledWidth, h = unscaledHeight;
    double wd = w - vm.left - vm.right;
    double ht = h - vm.top - vm.bottom;
    content.width = wd < 0 ? 0 : wd;
    content.height = ht < 0 ? 0 : ht;
    content.x = vm.left;
    content.y = vm.top;
    
    content.mask = maskShape;
}

protected void mouseWheelHandler(MouseEvent event) {
	
	/*
	* Bug in Flex. The mouse wheel handler in  ScrollControlBase
	* does not respect the maximum and minimum values of the scrollbar.
	* The fix is to reimplement mouse wheel handler.
	*/
	if (verticalScrollBar != null && verticalScrollBar.visible) {
        event.stopPropagation();
        //TODO do not use verticalScrollPosition cause it can be wrong, see ScrollBar.setSelection
        double oldPosition = verticalScrollBar.scrollPosition;
        double newPosition = oldPosition - event.delta * verticalScrollBar.lineScrollSize;
        newPosition = Math.max(verticalScrollBar.minScrollPosition, Math.min(newPosition, verticalScrollBar.maxScrollPosition));
        if (oldPosition != newPosition) {
        	verticalScrollPosition = newPosition;
        	ScrollEvent scrollEvent = new ScrollEvent(ScrollEvent.SCROLL);
            scrollEvent.direction = ScrollEventDirection.VERTICAL;
            scrollEvent.position = newPosition;
            scrollEvent.delta = newPosition - oldPosition;
            dispatchEvent(scrollEvent);
        }
	}
}
}
